
kEventNotifierID = "notifierBtn";
kNotifierTag = "_notifier";

kLastCmdResultID = "lastCmdResult";

kTrueVal = "1";
kFalseVal = "0";

_gDataIDs = null;
_gDataIDsCnt = 0;

kProgressBarPercentNotifier = "progressBarPercent_notifier";

//----------------------------------------------------------------------------
function queryProgressBarPercentSetup()
{
	var s='<div>';
	s += '<input id="' + kProgressBarPercentNotifier + '" type="text">';
	s += '</div>';
	document.body.insertAdjacentHTML( "beforeBegin", s );
}

//----------------------------------------------------------------------------
function queryProgressBarPercent()
	// Fire event to C++ DHtml event handler in afDHtmlManagerDialog.cpp
	// to return the percentage from Internet client callback.  The event
	// is fired to the dialog iframe defined in stateDownload.htm.  So, queryProgressBarPercentSetup()
	// must be called there in order for the kProgressBarPercentNotifier event to be
	// rerouted from the iframe to C++.
{
	var e = document.getElementById( kProgressBarPercentNotifier );
	if ( e )
	{
		e.title = kProgressBarPercentNotifier;
		e.fireEvent("onclick");
		return e.title;
	}
	return "";
}

//-----------------------------------------------------------------------------
function insertDataExchangeItems( items )
{
	if (!items) return;
	_gDataIDs = items; // save off a reference for later use
	_gDataIDsCnt = items.length;

	var s='<div style="position:absolute;left:-200px;top:0px;width:200px;visibility:hidden">';	
	
	// Create item for event notification with the C++ dialog
	s+='<input id="'+ kEventNotifierID +'" type="button">';
		
	// Create items for data exchange with the C++ dialog
	for (var i=0; i<_gDataIDsCnt; i++) s += '<span id="' + items[i] + '"></span>';
	
	s += '</div>';
	document.body.insertAdjacentHTML( "beforeBegin", s );
}

//-----------------------------------------------------------------------------
// Event notifiers helpers - helps to trigger events in C++ code
//-----------------------------------------------------------------------------
function _notify( id, cmd )
	// Fire a notify event of the specified type.
{
	var e = document.getElementById( kEventNotifierID );
	if ( e )
	{
		var realID = id + kNotifierTag;
		e.id = realID;
		e.title = (cmd) ? cmd : "";
		e.fireEvent("onclick");
		e.id = kEventNotifierID;
	}	
}

//-----------------------------------------------------------------------------
function onOK() { _notify( "ok" ); }
	// Notify OK was clicked

//-----------------------------------------------------------------------------------------------
function onCancel() { _notify( "cancelX" ); }
	// Notify cancel was clicked

//-----------------------------------------------------------------------------------------------
function onCmd(cmd) { _notify( "cmd", cmd ); }

//-----------------------------------------------------------------------------
// Data Src helpers
//-----------------------------------------------------------------------------
function initDlgData(dlgWin) { _init_save_Data( dlgWin, false ); }
	// Set data items in the datasrc into the dialog page, specified by dlgWin

//-----------------------------------------------------------------------------
function saveDlgData(dlgWin) { _init_save_Data( dlgWin, true ); }
	// Update data items in the datasrc from the dialog page, specified by dlgWin

//-----------------------------------------------------------------------------
function _init_save_Data( dlgWin, bSave )
{
	if (!dlgWin) return;
	
	var id, a, dataSrcItem=null, pageItem=null, srcVal=null, tag;
	
	for( var i=0; i<_gDataIDsCnt; i++ )
	{
		a = null;
		id = _gDataIDs[i];
				
		// Look for elements matching each data ID in the dialog page
		pageItem = dlgWin.document.getElementById( id );
		if( pageItem && pageItem.id==id ) tag = pageItem.tagName; // check id...sometime matches name
		else
		{
			// Look up matching elements by name on the dialog page (i.e. radio buttons,checkboxes)
			pageItem = null;
			a = dlgWin.document.getElementsByName( id );
			if ( a.length==0 ) continue;
			tag = a[0].tagName;
		}
		
		dataSrcItem = document.getElementById( id );
		if(!dataSrcItem) continue;
				
		switch( tag.toLowerCase() )
		{
			case "input":
				if(bSave) dataSrcItem.innerText = getInputElementData( dlgWin.document, pageItem, a );
				else setInputElementData( pageItem, a, dataSrcItem.innerText );
				break;
				
			case "select":
				if(bSave) dataSrcItem.innerText = getSelectElementData( pageItem );
				else setSelectElementData( pageItem, dataSrcItem.innerText );
				break;
				
			default:
				if(bSave) dataSrcItem.innerText = pageItem.innerText;
				else pageItem.innerText=dataSrcItem.innerText;
				break;	
		}
	}
}

//-----------------------------------------------------------------------------
function setInputElementData( e, a, val )
	// set a value on the input element, e or array of elements a
{
	if(!e)
	{
		if(a) e=a[0];
		else return;
	}
	
	switch ( e.type.toLowerCase() )
	{
		case "text":
			if ( e.value != val ) e.value = val;
			break;
			
		case "radio":
			if(!a) break;

			var cnt = a.length;
			for( var i=0; i<cnt; i++ )
			{
				if( a[i].value==val )
				{
					a[i].checked = true;
					break;
				}	
			}			
			break;
			
		case "checkbox":
			if(a)
			{
				// Checkbox group
				//
				// Value is a list of comma separated values
				// The checkboxes with a value listed in the list of values
				// are checked.
				var cnt = a.length;
				var sels = val.split(',');
				var numSels = sels.length;				
				var i,j;
				
				for( j=0; j<numSels; ++j )
				{
					for( i=0; i<cnt; ++i )
					{
						if( a[i].value==sels[j] ) a[i].checked = true;
					}
				}
			}
			else e.checked = (val==kTrueVal);
				// Standalone checkbox
					
			break;			
	}	
}

//-----------------------------------------------------------------------------
function getInputElementData( doc, e, a )
	// return the value associated with the input element, e
{
	if(!e)
	{
		if(a) e=a[0];
		else return;
	}

	var val = "";
	
	switch ( e.type.toLowerCase() )
	{
		case "text":
			val = e.value;
			break;
			
		case "radio":
			if(!doc)return;						
			var btns = doc.getElementsByName(e.name);
			var cnt = btns.length;
			for( var i=0; i<cnt; i++ )
			{
				if (btns[i].checked)
				{
					val = btns[i].value;
					break;
				}
			}			
			break;
			
		case "checkbox":
			if(a)
			{
				// Checkbox group
				//
				// Value is a list of comma separated values of 
				// values associated with checkboxes in the group that
				// are checked.
				var cnt = a.length;
				var bHasValue = false;
				
				for( var i=0; i<cnt; ++i )
				{
					if( a[i].checked )
					{
						if( bHasValue ) val+= ',';
						else bHasValue = true;
						
						val += a[i].value;
					}	
				}
			}
			else val = (e.checked) ? kTrueVal : kFalseVal;
				// Standalone checkbox
				
			break;	
	}	
	
	return val;
}

//-----------------------------------------------------------------------------
function setSelectElementData( e, val )
	// set a value on the select element, e
{
	var optCnt = e.options.length;
	var selIndex = -1;
	for( var i=0; i<optCnt; i++ )
	{
		if( e.options[i].value == val )
		{
			selIndex = i;
			break;
		}
	}

	if( selIndex>=0 && e.selectedIndex!=selIndex ) e.selectedIndex=selIndex;
}

//-----------------------------------------------------------------------------
function getSelectElementData(e,val) { return e.options[e.selectedIndex].value; }
	// return the value associated with the select element, e

//-----------------------------------------------------------------------------
function getLastCmdResult() { return dataSrcItem(kLastCmdResultID); }
	// Get the last command result

//-----------------------------------------------------------------------------
var gLastCmdResultList = null;

function getLastCmdResultList() { return gLastCmdResultList; }
	// Get the last command result list

function _setLastCmdResultList()
	// Called by the C++ to pass in a list of results.
{
	gLastCmdResultList = null;

	// Create a list of the results based on the arguments passed in
   var argCnt = arguments.length;
   if( 0 == argCnt ) return;
   
	gLastCmdResultList = new Array( argCnt );
   
   for( var i=0; i < argCnt; ++i ) gLastCmdResultList[i] = arguments[i];
}


//-----------------------------------------------------------------------------
function setDataSrcItem(id,val)
	// Sets the value associated with the specified data item
{	
	if( !val ) val="";
	
	var src = document.getElementById(id);
	if( src ) src.innerText =  val;
}

//-----------------------------------------------------------------------------
function dataSrcItem(id)
	// Returns the value associated with the data item
{
	var val = null;
	var src = document.getElementById(id);
	if( src ) val = src.innerText;

	return val;
}

